<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class AppInstall extends Command
{
    protected $signature = 'app:install';
    protected $description = 'Install POS system (composer, migrate, seed)';

    public function handle()
    {
        $this->info('Installing POS system...');

        $this->callSilent('key:generate');

        $this->callSilent('migrate', ['--force' => true]);
        $this->callSilent('db:seed', ['--force' => true]);
        $this->callSilent('storage:link');

        $this->info('POS installation completed.');
    }
}
